/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.report.htmlreport;

import oracle.ops.verification.framework.report.htmlreport.HtmlConstants;
import oracle.ops.verification.framework.report.htmlreport.Table;
import oracle.ops.verification.framework.report.htmlreport.Text;

public class TableCell {
    private HtmlConstants.Colors m_BackGroundColor = null;
    private Object m_elementObj = null;
    private HtmlConstants.DataTypes m_type = null;
    private HtmlConstants.VeriticalAlignment m_alignVertical = null;
    private HtmlConstants.HorizontalAlignment m_alignHorizontal = null;
    private int m_height = 0;
    private int m_width = 0;
    private boolean m_wrapText = true;
    private int m_rowSpan = 1;
    private int m_colSpan = 1;

    public TableCell(Table table, HtmlConstants.Colors backGroundColor, HtmlConstants.VeriticalAlignment alignVeritcal, HtmlConstants.HorizontalAlignment alignHorizontal) {
        this.m_alignVertical = alignVeritcal;
        this.m_alignHorizontal = alignHorizontal;
        this.m_elementObj = table;
        this.m_type = HtmlConstants.DataTypes.TABLE;
        if (backGroundColor != null) {
            this.m_BackGroundColor = backGroundColor;
        }
    }

    public TableCell(Text txt, HtmlConstants.Colors backGroundColor, HtmlConstants.VeriticalAlignment alignVertical, HtmlConstants.HorizontalAlignment alignHorizontal) {
        this.m_alignVertical = alignVertical;
        this.m_alignHorizontal = alignHorizontal;
        this.m_elementObj = txt;
        this.m_type = HtmlConstants.DataTypes.TEXT;
        if (backGroundColor != null) {
            this.m_BackGroundColor = backGroundColor;
        }
    }

    public TableCell(Text[] txt, HtmlConstants.Colors backGroundColor, HtmlConstants.VeriticalAlignment alignVertical, HtmlConstants.HorizontalAlignment alignHorizontal) {
        this.m_alignVertical = alignVertical;
        this.m_alignHorizontal = alignHorizontal;
        this.m_elementObj = txt;
        this.m_type = HtmlConstants.DataTypes.TEXT_ARRAY;
        if (backGroundColor != null) {
            this.m_BackGroundColor = backGroundColor;
        }
    }

    public void setWrapText(boolean flag) {
        this.m_wrapText = flag;
    }

    public boolean isTextWrapped() {
        return this.m_wrapText;
    }

    public void setVeriticalAlignment(HtmlConstants.VeriticalAlignment align) {
        this.m_alignVertical = align;
    }

    public HtmlConstants.VeriticalAlignment getVerticalAlignment() {
        return this.m_alignVertical;
    }

    public void setHorizontalAlignment(HtmlConstants.HorizontalAlignment align) {
        this.m_alignHorizontal = align;
    }

    public HtmlConstants.HorizontalAlignment getHorizontalAlignment() {
        return this.m_alignHorizontal;
    }

    public boolean isVerticallyAligned() {
        return this.m_alignVertical != null;
    }

    public boolean isHorizontallyAligned() {
        return this.m_alignHorizontal != null;
    }

    public void setHeight(int height) {
        this.m_height = height > 100 ? 100 : height;
    }

    public int getHeight() {
        return this.m_height;
    }

    public void setWidth(int width) {
        this.m_width = width > 100 ? 100 : width;
    }

    public int getWidth() {
        return this.m_width;
    }

    public void setBackGroundColor(HtmlConstants.Colors color) {
        if (color != null) {
            this.m_BackGroundColor = color;
        }
    }

    public void setRowSpan(int rowSpan) {
        this.m_rowSpan = rowSpan;
    }

    public int getRowSpan() {
        return this.m_rowSpan;
    }

    public void setColSpan(int colSpan) {
        this.m_colSpan = colSpan;
    }

    public int getColSpan() {
        return this.m_colSpan;
    }

    public HtmlConstants.Colors getBackGroundColor() {
        return this.m_BackGroundColor;
    }

    public HtmlConstants.DataTypes getType() {
        return this.m_type;
    }

    public Object getObject() {
        return this.m_elementObj;
    }
}

